<?php

namespace App\Http\Controllers\Therapists;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;
use App\Http\Requests\Therapists\TherapistServices\CreateRequest;
use App\Http\Resources\Web\ServicesResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistServicesController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist');
      // $this->middleware('permission:therapist_services.index');
      // $this->middleware('permission:therapist_services.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_services.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_services.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_services.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_services.import',['only' => ['import']])
      // $this->middleware('permission:therapist_services.update|therapist_services.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_services =  $therapist->therapist_services()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_services =  $therapist_services->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_services =  $therapist_services->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_services = $therapist_services->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_services = $therapist_services->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_services = $therapist_services->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_services = $therapist_services->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_services = $therapist_services->get();
        return $therapist_services;
      }
      $totalTherapistServices = $therapist_services->count();
      $therapist_services = $therapist_services->paginate($req->perPage);
      $therapist_services = ServicesResource::collection($therapist_services)->response()->getData(true);

      return $therapist_services;
    }
    $therapist_services = ServicesResource::collection($therapist->therapist_services()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_services;
  }

  /********* FETCH ALL TherapistServices ***********/
    public function index()
    {
        $therapist_services =  $this->getter();
        $response = generateResponse($therapist_services,count($therapist_services['data']) > 0 ? true:false,'TherapistServices Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistServices FOR Search ***********/
   public function filter(Request $request){
     $therapist_services = $this->getter($request);
     $response = generateResponse($therapist_services,count($therapist_services['data']) > 0 ? true:false,'Filter TherapistServices Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistService ***********/
    public function store(CreateRequest $request)
    {
        $settings = generalSettings();
      $therapist = auth()->user()->therapist;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadCroppedFile($request,'image','therapist_services');
      $data['audio'] = uploadFile($request,'audio','therapist_services');
      $data['video'] = uploadFile($request,'video','therapist_services');
      $therapist_service = $therapist->therapist_services()->create($data);
      if((int)$settings['auto_approve_therapist_service']){
        $therapist_service->is_approved = 1;
        $therapist_service->approved_at = now();
      }
      $therapist_service->slug = Str::slug($therapist_service->name . ' ' . $therapist_service->id, '-');
      $therapist_service->save();
      $therapist_service = $therapist->therapist_services()->withAll()->find($therapist_service->id);
      $therapist_service = new ServicesResource($therapist_service);
      $therapist_service->tags()->sync($request->tag_ids);
      if($request->faqs){
        $therapist_service->faqs()->createMany($request->faqs);
      }
      DB::commit();
    }
      catch (\Exception $e) {
        DB::rollBack();
        request()->session()->flash('alert',['message' => $e->getMessage(),'type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_service)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_service->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_service = $therapist->therapist_services()->withAll()->find($therapist_service);
        if($therapist_service){
          $therapist_service = new ServicesResource($therapist_service);
          $response = generateResponse($therapist_service,true,'TherapistService Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistService Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistService ***********/
    public function update(CreateRequest $request, Service $therapist_service)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_service->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_services',$therapist_service->image);
        } else {
            $data['image'] = $therapist_service->image;
        }

        if ($request->audio) {
            $data['audio'] = uploadFile($request,'audio','therapist_services');
        } else {
            $data['audio'] = $therapist_service->audio;
        }

        if ($request->video) {
            $data['video'] = uploadFile($request,'video','therapist_services');
        } else {
            $data['video'] = $therapist_service->video;
        }
        $therapist_service->update($data);
        $therapist_service = $therapist_service->find($therapist_service->id);
        $slug = Str::slug($therapist_service['name'] . ' ' . $therapist_service->id, '-');
        $therapist_service->update(
            [
                'slug' => $slug
            ]
        );
        $therapist_service->tags()->sync($request->tag_ids);
        if($request->faqs){
            $therapist_service->faqs()->delete();
            $therapist_service->faqs()->createMany($request->faqs);
          }
        DB::commit();
      }
        catch (\Exception $e) {
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistService Status***********/
    public function updateStatus(Request $request,Service $therapist_service){
        $therapist = auth()->user()->therapist;
        if($therapist_service->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_service->update([
          'is_active' => $therapist_service->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistService Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistService ***********/
    public function destroy(Request $request,Service $therapist_service)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_service->therapist_id != $therapist->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_service->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_service->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistService ***********/
    public function destroyPermanently(Request $request,$therapist_service)
    {
        $therapist= auth()->user()->therapist;
        $therapist_service = $therapist->therapist_services()->withTrashed()->find($therapist_service);
        if($therapist_service){
            if($therapist_service->therapist_id != $therapist->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_service->trashed()) {
            $therapist_service->forceDelete();
            $response = generateResponse(null,true,'TherapistService Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistService is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistService not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistService ***********/
    public function restore(Request $request,$therapist_service)
    {
      $therapist= auth()->user()->therapist;
      $therapist_service = $therapist->therapist_services()->withTrashed()->find($therapist_service);
          if ($therapist_service->trashed()) {
            $therapist_service->restore();
            $response = generateResponse(null,true,'TherapistService Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistService is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
